data{
    int<lower=1> n;
    // when defining a vector/matrix/array, have to declare dimensions
    vector[5] x; 
}
parameters{
    real mu;
    real<lower=0> sigma;
}
model{
    // likelihood
    for(i in 1:n){
        x[i] ~ normal(mu,sigma);
    }
    // priors
    mu ~ normal(0,1000);
    sigma ~ uniform(0,100);
}